define(['angular', 'app'], function(angular, app) {
    'use strict';
	app.constant('TrackersConstants', {
		'glucose': {
			summary: {
				table : {
					columns : [
						{ label: 'Glucose Level (mg/dl)', keys: 'valueQuantity.value', cellTemplate: 'src/modules/trackers/pages/summary/partials/_glucose-table-entry.html' },
						{ label: 'Tested', keys: 'component[0].valueString', class: {column: 'hidden-xs'} },
						{ label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
						{ label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } }
					]
				},
				testConditions: ['Fasting (8 hours)', 'After Meal', 'Unknown']
			},
			entry: {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_glucose.html',
				vitalObservationsMeta:[
					{
						label : 'Glucose Level',
						units : 'mg/dl',
						min : '0',
						max : '600',
						validationExpression : /(^0?[1-9][0-9]$)|(^[1-5][0-9]{2}$)|(^600$)/,
						userInputPattern : /(^[1-9][0-9]{0,2}$)|(^0$)/
					}
				],
				testConditions: ['Fasting (8 hours)', 'After Meal', 'Unknown']
			},
			name: 'Glucose'
		},
		'bp-pulse': {
			summary : {
				table : {
					columns : [
						{label: 'Systolic (mmHg)', keys: 'component[0].valueQuantity.value'},
						{label: 'Diastolic (mmHg)', keys: 'component[1].valueQuantity.value'},
						{label: 'Pulse (bpm)', keys: 'component[2].valueQuantity.value'},
						{label: 'Position', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
						{label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html'},
						{label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } }
					]
				}
			},
			entry : {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_bp-pulse.html',
				method : {
					label : 'Position',
					options : [ 'Standing', 'Sitting', 'Lying' ]
				},
				vitalObservationsMeta:[
					{
						label : 'Systolic',
						units : 'mmHg',
						min : '60',
						max : '300',
						validationExpression : /(^0?[89][0-9]$)|(^[12][0-9]{2}$)|(^300$)/,
						userInputPattern : /(^[1-9][0-9]{0,2}$)|(^0$)/
					},
					{
						label : 'Diastolic',
						units : 'mmHg',
						min : '0',
						max : '200',
						validationExpression : /(^0?[89][0-9]$)|(^[12][0-9]{2}$)|(^200$)/,
						userInputPattern : /(^[1-9][0-9]{0,2}$)|(^0$)/
					},
					{
						label : 'Pulse',
						units : 'bpm',
						min : '20',
						max : '250',
						validationExpression : /(^0?[4-9][0-9]$)|(^1[0-9]{2}$)|(^2[0-4][0-9]$)|(^250$)/,
						userInputPattern : /(^[1-9][0-9]{0,2}$)|(^0$)/
					}
				]
			},
			name: 'Blood Pressure and Pulse'
		},
		'weight' : {
			summary : {
				table : {
					columns : [
						{label: 'Weight (lbs)', keys: 'valueQuantity.value'},
						{label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html'},
						{label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html'}
					]
				}
			},
			entry : {
				entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_weight.html',
				vitalObservationsMeta:[
					{
						label : 'Weight',
						units : 'lbs',
						min : '0.0',
						max : '999.9',
						validationExpression : /^[0-9]{0,3}([.][0-9])?$/,
						userInputPattern : /^[1-9][0-9]{0,2}([.][0-9]?)?$|(^0([.][0-9]?)?$)/
					}
				]
			},
			name: 'Weight'
		},
        'cholesterol' : {
            summary : {
                table : {
                    columns : [
                        {label: 'Total (mg/dl)', keys: 'component[0].valueQuantity.value'},
                        {label: 'LDL (mg/dl)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'HDL (mg/dl)', keys: 'component[2].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Triglycerides (mg/dl)', keys: 'component[3].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Fasting?', keys: 'component[4].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } }
                    ]
                },
            },
            entry : {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_cholesterol.html',
                method : {
                    label : 'Tested',
                    options : [ 'Fasting', 'After Meal', 'Unknown' ]
                },
                vitalObservationsMeta:[
                    {
                        label : 'Cholesterol Level',
                        screenLabel: 'Total Serum Cholesterol',
                        units : 'mg/dl',
                        min : '0',
                        max : '600',
                        validationExpression : /(^0?[0-9]{1,2}$)|(^[1-5][0-9]{2}$)|(^600$)/,
                        userInputPattern : /(^0?[0-9]{1,2}$)|(^[1-5][0-9]{2}$)|(^600$)/
                    },
                    {
                        label : 'LDL',
                        screenLabel: 'Low-Density Lipoprotein (LDL)',
                        units : 'mg/dl',
                        min : '0',
                        max : '300',
                        validationExpression : /(^0?[0-9]{1,2}$)|(^[1-2][0-9]{2}$)|(^300$)/,
                        userInputPattern : /(^0?[0-9]{1,2}$)|(^[1-2][0-9]{2}$)|(^300$)/
                    },
                    {
                        label : 'HDL',
                        screenLabel: 'High-Density Lipoprotein (HDL)',
                        units : 'mg/dl',
                        min : '0',
                        max : '300',
                        validationExpression : /(^0?[0-9]{1,2}$)|(^[1-2][0-9]{2}$)|(^300$)/,
                        userInputPattern : /(^0?[0-9]{1,2}$)|(^[1-2][0-9]{2}$)|(^300$)/
                    },
                    {
                        label : 'Triglycerides',
                        screenLabel: 'Triglycerides',
                        units : 'mg/dl',
                        min : '0',
                        max : '600',
                        validationExpression : /(^0?[0-9]{1,2}$)|(^[1-5][0-9]{2}$)|(^600$)/,
                        userInputPattern : /(^0?[0-9]{1,2}$)|(^[1-5][0-9]{2}$)|(^600$)/
                    }
                ],
                testConditions: ['Fasting (8 hours)', 'After Meal', 'Unknown']
            },
            name: 'Cholesterol'
        },
        'mood': {
            summary: {
                table : {
                    columns : [{
                        label: 'Mood Rating (1=Worst, 10=Best)',
                        keys: 'valueQuantity.value',
                        cellTemplate: 'src/ui-components/table/partials/_icon.html',
                        ngIconClass: function (item) { return {
                            'icon-mood-verybad': item.valueQuantity.value < 3,
                            'icon-mood-verygood': item.valueQuantity.value > 8,
                            'icon-mood-neutral': (item.valueQuantity.value === 5 || item.valueQuantity.value === 6),
                            'icon-mood-bad': (item.valueQuantity.value === 3 || item.valueQuantity.value === 4),
                            'icon-mood-good': (item.valueQuantity.value === 7 || item.valueQuantity.value === 8) };
                        }
                    },
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html'},
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html'}

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_mood.html',
                options : [ '1', '2', '3','4', '5', '6' ,'7', '8', '9', '10'  ],
                vitalObservationsMeta:[
                    {
                        label : 'Mood Ratings',
                        units : '1 = Worst, 10 = Best',
                        min : '0',
                        max : '10',
                        validationExpression : /(^[0-9]$)|(^10$)/,
                        userInputPattern : /(^[0-9]$)|(^10$)/
                    }
                ]
            },
            name: 'Mood'
        },
        'fitness-activity': {
            summary: {
                table : {
                    columns : [
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration',
                        units : 'minutes',
                        min : '0',
                        max : '1440',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
                        userInputPattern : /^[0-9]{0,4}$/
                    },

                    {
                        name : 'miles',
                        label : 'Distance',
                        units : 'miles',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ],
                steps : {
                    name : 'steps',
                    label : 'Distance',
                    units : 'steps',
                    min : '0.1',
                    max : '50000',
                    validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                    userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                },
                extensioncategory : {
                    name : 'category',
                    label : 'Category',
                    min : '0.1',
                    max : '50000',
                },
                intensity: {
                    label: 'Exercise Intensity',
                    options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
                },
                exerciseactivity: {
                    label: 'Exercise Activity',
                    options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
                },
            },
            name: 'Fitness Activity'
        },
        'fitnessActivities': {
            summary: {
                table : {
                    columns : [
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration',
                        units : 'minutes',
                        min : '0',
                        max : '1440',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
                        userInputPattern : /^[0-9]{0,4}$/
                    },
                    {
                        name : 'steps',
                        label : 'Steps',
                        min : '0',
                        max : '50000',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
                        userInputPattern : /^[0-9]{0,5}$/
                    },
                    {
                        name : 'miles',
                        label : 'Distance',
                        units : 'miles',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ],
                intensity: {
                    label: 'Exercise Intensity',
                    options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
                },
                exerciseactivity: {
                    label: 'Exercise Activity',
                    options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
                },
            },
            name: 'Fitness Activity'
        },
        'fitness-activity-legacy': {
            summary: {
                table : {
                    columns : [
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration',
                        units : 'minutes',
                        min : '0',
                        max : '1440',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
                        userInputPattern : /^[0-9]{0,4}$/
                    },
                    {
                        name : 'steps',
                        label : 'Steps',
                        min : '0',
                        max : '50000',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
                        userInputPattern : /^[0-9]{0,5}$/
                    },
                    {
                        name : 'miles',
                        label : 'Distance',
                        units : 'miles',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ],
                intensity: {
                    label: 'Exercise Intensity',
                    options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
                },
                exerciseactivity: {
                    label: 'Exercise Activity',
                    options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
                },
            },
            name: 'Fitness Activity'
        },
        'fitness-goals-legacy': {
            summary: {
                table : {
                    columns : [
                        {label: 'Date/Time', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Activity', keys: 'component[3].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Intensity', keys: 'component[2].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-activity.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration',
                        units : 'minutes',
                        min : '0',
                        max : '1440',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
                        userInputPattern : /^[0-9]{0,4}$/
                    },
                    {
                        name : 'steps',
                        label : 'Steps',
                        min : '0',
                        max : '50000',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
                        userInputPattern : /^[0-9]{0,5}$/
                    },
                    {
                        name : 'miles',
                        label : 'Distance',
                        units : 'miles',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ],
                intensity: {
                    label: 'Exercise Intensity',
                    options: ['Very Easy', 'Easy', 'Somewhat Easy', 'Somewhat Hard', 'Hard', 'Very Hard']
                },
                exerciseactivity: {
                    label: 'Exercise Activity',
                    options: ['Walking', 'Running', 'Cycling', 'Swimming', 'Dancing', 'Tennis', 'Hiking', 'Strength Exercise', 'Housework', 'Gardening', 'Golf', 'Yoga', 'Rowing', 'Stairs', 'Sports', 'General Calisthenics', 'Other']
                },
            },
            name: 'Fitness Goals'
        },
        'goalHistory': {
            summary: {
                table : {
                    columns : [
                        {label: 'Date Entered', keys: 'activityDate'},
                        {label: 'Duration (min)', keys: 'value.minutes', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'value.steps', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'value.miles', class: {column: 'hidden-xs'}},

                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-goals.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration (minutes)',
                        min : '0',
                        max : '10080',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
                        userInputPattern : /^[0-9]{0,5}$/
                    },
                    {
                        name : 'steps',
                        label : 'Steps',
                        min : '0',
                        max : '50000',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,4}$)/,
                        userInputPattern : /^[0-9]{0,5}$/
                    },
                    {
                        name : 'miles',
                        label : 'Distance (miles)',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ]
            }
        },
        'fitness-goals': {
            summary: {
                table : {
                    columns : [
                        {label: 'Entry Date', keys: 'effectiveDateTime', cellTemplate: 'src/modules/trackers/pages/summary/partials/_date-time.html' },
                        {label: 'Start Date', keys: 'extension[4].valueString', class: { column: 'hidden-xs' } },
                        {label: 'Duration (min)', keys: 'component[0].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Distance (miles)', keys: 'component[1].valueQuantity.value', class: {column: 'hidden-xs'}},
                        {label: 'Steps', keys: 'extension[1].valueString', class: {column: 'hidden-xs'}},
                        {label: 'Met', keys: 'value.met', class: { column: 'hidden-xs' } },
                        {label: 'Note', keys: 'comments', cellTemplate: 'src/modules/trackers/pages/summary/partials/_notes-icon.html', class: { column: 'hidden-xs' } },
                    ]
                }
            },
            entry: {
                entryInputsTemplate : 'src/modules/trackers/pages/entry/partials/_fitness-goals.html',

                vitalObservationsMeta:[
                    {
                        name : 'minutes',
                        label : 'Duration',
                        units : 'minutes',
                        min : '0',
                        max : '1440',
                        validationExpression : /(^0$)|(^[1-9][0-9]{0,3}$)/,
                        userInputPattern : /^[0-9]{0,4}$/
                    },

                    {
                        name : 'miles',
                        label : 'Distance',
                        units : 'miles',
                        min : '0.1',
                        max : '50000',
                        validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                        userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                    }
                ],
                steps : {
                    name : 'steps',
                    label : 'Distance (steps)',
                    units : 'steps',
                    min : '0.1',
                    max : '50000',
                    validationExpression : /^[0-9]{0,5}([.][0-9]{0,2})?$/,
                    userInputPattern : /^[0-9]{0,5}([.][0-9]{0,2})?$/
                },
                extensioncategory : {
                    name : 'category',
                    label : 'Category',
                    min : '0.1',
                    max : '50000',
                },
                extensionstartdate : {
                    name : 'startDate',
                    label : 'Start Date',
                },
                extensionenddate : {
                    name : 'endDate',
                    label : 'EndDate',
                },
                extensionactiveflag : {
                    name : 'activeFlag',
                    label : 'Active Flag',
                    options: ['false', 'true']
                }
            },
            name: 'Fitness Goal'
        },
	});

});